<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
 
$routes->set404Override(function() {
    $data = ['pageTitle' => '404'];
    $data['settings'] = [
        'site_description' => 'Oops! The requested URL was not found on this server.',
        'site_keywords' => 'Oops, 404',
        'app_name' => 'Page Not Found :('
    ];
    echo view('404', $data);
});

$routes->get('/', 'AuthController::index');
$routes->get('/info', 'Home::index');

// API -------------------------------------------------------------------------
$routes->add('/api', 'ApiController::index');
$routes->add('/api-web', 'ApiWebController::index');

$routes->get('/privacy-policy', 'PanelController::policy_index');
$routes->get('/terms', 'PanelController::terms_index');

$routes->get('/description-radio/(:num)', 'RadiosController::description/$1');
$routes->get('/description-podcast/(:num)', 'PodcastController::description/$1');

$routes->get('/account-delete-request', 'DataDeletioController::create');
$routes->get('/account-request-done', 'DataDeletioController::create_done');
$routes->add('/create_extream_handler', 'DataDeletioController::createHandler');

$routes->get('/ns-admin', 'AuthController::index');
$routes->group('ns-admin', static function($routes){
    
    // Login -------------------------------------------------------------------
    $routes->get('login', 'AuthController::loginForm');
    $routes->get('logout', 'AuthController::logout');
    $routes->add('login_handler', 'AuthController::loginHandler');
    
    // Register----------------------------------------------------------
    $routes->get('register', 'AuthController::registerForm');
    $routes->add('register_handler', 'AuthController::registerHandler');
    
    // Forgot password----------------------------------------------------------
    $routes->get('forgot-password', 'AuthController::forgotPassword');
    $routes->add('forgot_handler', 'AuthController::forgotPasswordHandler');
    
    // Profile----------------------------------------------------------
    $routes->get('profile', 'AuthController::profileForm');
    $routes->add('profile_handler', 'AuthController::profileHandler');
    
    // Dashboard----------------------------------------------------------------
    $routes->get('dashboard', 'PanelController::index');
    
    // category ----------------------------------------------------------------
    $routes->get('manage-category', 'CategoryController::index');
    $routes->get('create-category', 'CategoryController::create');
    $routes->get('create-category/(:num)', 'CategoryController::edit/$1');
    $routes->add('create_category_handler', 'CategoryController::createHandler');
    $routes->add('delete-category/(:num)', 'CategoryController::delete/$1');
    $routes->add('status-category/(:num)', 'CategoryController::status/$1');
    
    // Countries ----------------------------------------------------------------
    $routes->get('manage-countries', 'CountriesController::index');
    $routes->get('create-countries', 'CountriesController::create');
    $routes->get('create-countries/(:num)', 'CountriesController::edit/$1');
    $routes->add('create_countries_handler', 'CountriesController::createHandler');
    $routes->add('delete-countries/(:num)', 'CountriesController::delete/$1');
    $routes->add('status-countries/(:num)', 'CountriesController::status/$1');
    
    // Radios ------------------------------------------------------------------
    $routes->get('manage-radios', 'RadiosController::index');
    $routes->get('create-radio', 'RadiosController::create');
    $routes->get('create-radio/(:num)', 'RadiosController::edit/$1');
    $routes->add('create_radio_handler', 'RadiosController::createHandler');
    $routes->add('delete-radio/(:num)', 'RadiosController::delete/$1');
    $routes->add('status-radio/(:num)', 'RadiosController::status/$1');
    
    // Podcast ------------------------------------------------------------------
    $routes->get('manage-podcast', 'PodcastController::index');
    $routes->get('create-podcast', 'PodcastController::create');
    $routes->get('create-podcast/(:num)', 'PodcastController::edit/$1');
    $routes->add('create_podcast_handler', 'PodcastController::createHandler');
    $routes->add('delete-podcast/(:num)', 'PodcastController::delete/$1');
    $routes->add('status-podcast/(:num)', 'PodcastController::status/$1');
    
    // Episode ------------------------------------------------------------------
    $routes->get('manage-episode', 'EpisodeController::index');
    $routes->get('create-episode', 'EpisodeController::create');
    $routes->get('create-episode/(:num)', 'EpisodeController::edit/$1');
    $routes->add('create_episode_handler', 'EpisodeController::createHandler');
    $routes->add('delete-episode/(:num)', 'EpisodeController::delete/$1');
    $routes->add('status-episode/(:num)', 'EpisodeController::status/$1');
    
    // Banner ------------------------------------------------------------------
    $routes->get('manage-banner', 'BannerController::index');
    $routes->get('create-banner', 'BannerController::create');
    $routes->get('create-banner/(:num)', 'BannerController::edit/$1');
    $routes->add('create_banner_handler', 'BannerController::createHandler');
    $routes->add('delete-banner/(:num)', 'BannerController::delete/$1');
    $routes->add('status-banner/(:num)', 'BannerController::status/$1');
    
    // Sections ----------------------------------------------------------------
    $routes->get('manage-sections', 'SectionsController::index');
    $routes->get('create-sections', 'SectionsController::create');
    $routes->get('create-sections/(:num)', 'SectionsController::edit/$1');
    $routes->add('create_sections_handler', 'SectionsController::createHandler');
    $routes->add('delete-sections/(:num)', 'SectionsController::delete/$1');
    $routes->add('status-sections/(:num)', 'SectionsController::status/$1');
    
    // Suggestion --------------------------------------------------------------
    $routes->get('manage-suggestion', 'SuggestionController::index');
    $routes->get('view-suggestion/(:num)', 'SuggestionController::edit/$1');
    $routes->add('delete-suggestion/(:num)', 'SuggestionController::delete/$1');
    
    // Notification-------------------------------------------------------------
    $routes->get('notification-onesignal', 'NotificationController::onesignal_index');
    $routes->add('onesignal_handler', 'NotificationController::onesignalHandler');
    
    $routes->get('notification-user', 'NotificationController::notifi_index');
    $routes->add('notification_handler', 'NotificationController::notifiHandler');
    
    // Reports -----------------------------------------------------------------
    $routes->get('manage-report', 'ReportsController::index');
    $routes->get('create-report/(:num)', 'ReportsController::edit/$1');
    $routes->add('create_report_handler', 'ReportsController::createHandler');
    $routes->add('delete-report/(:num)', 'ReportsController::delete/$1');
    
    // Subscription ------------------------------------------------------------
    $routes->get('manage-subscription', 'SubscriptionController::index');
    $routes->get('create-subscription', 'SubscriptionController::create');
    $routes->get('create-subscription/(:num)', 'SubscriptionController::edit/$1');
    $routes->add('create_subscription_handler', 'SubscriptionController::createHandler');
    $routes->add('delete-subscription/(:num)', 'SubscriptionController::delete/$1');
    
    // Users -------------------------------------------------------------------
    $routes->get('manage-users', 'UsersController::index');
    $routes->get('create-user', 'UsersController::create');
    $routes->get('create-user/(:num)', 'UsersController::edit/$1');
    $routes->add('create_user_handler', 'UsersController::createHandler');
    $routes->add('delete-user/(:num)', 'UsersController::delete/$1');
    $routes->add('status-user/(:num)', 'UsersController::status/$1');
    
    // Admin -------------------------------------------------------------------
    $routes->get('manage-admin', 'AuthController::admin_index');
    $routes->get('create-admin', 'AuthController::create');
    $routes->get('create-admin/(:num)', 'AuthController::edit/$1');
    $routes->add('create_admin_handler', 'AuthController::createAdminHandler');
    $routes->add('delete-admin/(:num)', 'AuthController::delete/$1');
    $routes->add('status-admin/(:num)', 'AuthController::status/$1');
    
    // Data Deletion Policy ----------------------------------------------------
    $routes->get('manage-data-deletion', 'DataDeletioController::index');
    $routes->add('delete-data-deletion/(:num)', 'DataDeletioController::delete/$1');
    
    // Sidebar -----------------------------------------------------------------
    $routes->get('create-sidebar', 'SidebarController::create');
    $routes->get('create-sidebar/(:num)', 'SidebarController::edit/$1');
    $routes->add('create_sidebar_handler', 'SidebarController::createHandler');
    $routes->add('delete-sidebar/(:num)', 'SidebarController::delete/$1');
    
    // Settings ----------------------------------------------------------------
    $routes->get('settings-panel', 'SettingsController::panel_index');
    $routes->get('settings-app', 'SettingsController::app_index');
    $routes->get('settings-web', 'SettingsController::web_index');
    $routes->get('settings-ads', 'SettingsController::ads_index');

    $routes->add('panel_handler', 'SettingsController::panelHandler');
    $routes->add('app_handler', 'SettingsController::appHandler');
    $routes->add('web_handler', 'SettingsController::webHandler');
    $routes->add('ads_handler', 'SettingsController::advertisementHandler');
    
    // Verification ------------------------------------------------------------
    $routes->get('verification', 'AuthController::verification_index');
    $routes->add('verification_handler', 'AuthController::verificationHandler');
    
    // Urls --------------------------------------------------------------------
    $routes->get('urls', 'PanelController::urls_index');
});